function JPasswordChangeDialog(owner, parent, name, caption, loginCode, minLength, rect)
{
	var self = this,
		_rendered = false,
		_disposed = false,
		_loginCode = loginCode,
		_minLength = minLength,
		edt_pwd, edt_confirmPwd,
		ok_btn, cancel_btn;

	this.initialize (owner, parent, name, null, null, rect);

	this.isForm   = true;
	this.previous = parent;
	this.methods  = (cmRender | cmLoad);
	this.caption  = this.owner.localize("dlgNewPassword");

	this.render  = render;
	this.load    = load;
	this.dispose = dispose;

	this.isRendered = isRendered;
	this.close   = close;

	this.owner.addImage("close-icon", "close.gif", "form");

	this.rect.normalize(this.owner.getDocument().body);

	this.owner.activeForm = this;

	function render(fs)
	{
		if (_rendered)
			return;

//		self.previous = self.owner.getObject(self.owner.activeForm);

		edt_pwd = self.owner.registerObject(self.name + "_pwd",  new JEdit(self.owner, self.name, self.name + "_pwd", null, null, ";;150;21", etSimple, null));
		edt_pwd.tabIndex = 1;
		edt_pwd.value = '';
		edt_pwd.controlType = 'password';
		self.addControl(edt_pwd);

		edt_confirmPwd = self.owner.registerObject(self.name + "_confirmPwd",  new JEdit(self.owner, self.name, self.name + "_confirmPwd", null, null, ";;150;21", etSimple, null));
		edt_confirmPwd.tabIndex = 2;
		edt_confirmPwd.controlType = 'password';
		edt_confirmPwd.value = '';
		self.addControl(edt_confirmPwd);

		ok_btn = self.owner.registerObject(self.name + "_OK", new JButton(self.owner, self.name, self.name + "_OK", self.owner.localize("capOK"), 1, ";;60;21", null, null));
		ok_btn.tabIndex = 3;
		ok_btn.click = OK_clicked;
		ok_btn.applyRect = true;
		self.addControl(ok_btn);

		cancel_btn = self.owner.registerObject(self.name + "_Cancel", new JButton(self.owner, self.name, self.name + "_Cancel", self.owner.localize("capCancel"), 1, ";;60;21", null, null));
		cancel_btn.tabIndex = 4;
		cancel_btn.click = Cancel_clicked;
		cancel_btn.applyRect = true;
		self.addControl(cancel_btn);

		var msg = (_loginCode == 2) ? self.owner.localize("msgPwdExpired") : self.owner.localize("msgPwdNotMinLength"); 

		fs.append('<div class="dialogForm" id="' + self.name + '" style="' + self.rect + '">');
		fs.append('  <div id="' + self.name + '_title" class="form_titlebar">');
		fs.append('    <span id="' + self.name + '_caption" class="form_caption">' + self.caption + '</span>');
		fs.append('  </div>');

		fs.append(	'<div class="dialogForm_inlet" id="' + self.name + '_inlet" style="top: ' + eval(fmDragbarHeight + fmBorderWidth) + 'px; height: ' + eval(self.rect.height - fmDragbarHeight - 3 * fmBorderWidth) + 'px; width: ' + eval(self.rect.width - 2 * fmBorderWidth) + 'px ">');
		fs.append(  '  <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse; overflow: scroll; width: ' + eval(self.rect.width - 2 * fmBorderWidth) + 'px">');
		fs.append(  '  <tr><td colspan="2" class="relLabel" style="text-align: center"><span id="' + self.name + '_Msg">' + msg + '</span></td></tr>');
		fs.append(  '  <tr><td colspan="2">&nbsp;</td></tr>');

		fs.append(  '  <tr><td class="relLabel" style="width:50">' + self.owner.localize("capPassword") + '</td><td>');
		edt_pwd.render(fs);
		fs.append(  '</td></tr>'); 

		fs.append(  '  <tr><td class="relLabel">' + self.owner.localize("capConfirmPassword") + '</td><td>');
		edt_confirmPwd.render(fs);
		fs.append(  '</td></tr>'); 

		fs.append(  '  <tr><td colspan="2">&nbsp;</td></tr>');
		fs.append(  '  <tr><td colspan="2" style="text-align: center">'); 
		ok_btn.render(fs);
		fs.append(  ' &nbsp; '); 
		cancel_btn.render(fs);
		fs.append(  '  </td></tr>'); 

		fs.append(	'</table>');
		fs.append(	'</div>');
		fs.append('</div>');
	}

	function load()
	{
		self.owner.getDocument().body.appendChild(self.$$());

		self.controls.forEach (function (control)
		{
			if (utils.inSet(cmLoad, control.methods))
				control.load();
		}, self);

		self.owner.setSplashInfo('');
		self.owner.splash(true);
		self.owner.splash(true);
		self.owner.setSplashInfo('');
		
		edt_pwd.$$().focus();
	}

	function isRendered()
	{
	  return _rendered;
	}

	function close()
	{
		self.owner.splash(false);
		self.$$().style.display = 'none';

		self.owner.unregisterObject(self.name);
		self.dispose();
	}

	function OK_clicked(e)
	{
		if (edt_pwd.value != edt_confirmPwd.value)
		{
			alert(self.owner.localize("msgPwdConfirmNoMatch"));
			edt_pwd.$$().focus();
			return;
		}

		if ((_minLength != '') && (_minLength != '0'))
		{
			var len = parseInt(_minLength);
			if (edt_pwd.value.length < len)
			{
				alert(self.owner.localize("msgPwdNotMinLength"));
				self.$$('_Msg').innerHTML = self.owner.localize("msgPwdNotMinLength");
				edt_pwd.$$().focus();
				return;
			}
		}

		var query  = new Postback();
		query.set("dat", escape(edt_pwd.value));
		self.owner.post(raNewPassword, query);

		close();
	}

	function Cancel_clicked(e)
	{
		var owner = self.owner;
		close();
		owner.logout();
	}

	function dispose()
	{
		if (_disposed)
			return;

		ok_btn.click = null;
		cancel_btn.click = null;

		self.disposeChildren();

		if (self.$$().parentNode != null)
			self.$$().parentNode.removeChild(self.$$());

		self.base.dispose.call(self);
		_disposed = true;
	}
}

JPasswordChangeDialog.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();